<?php
if (isset($result)) {
    $_GET = $_REQUEST;

    // check for required fields
	$is_required_field_missing = false;

    $search_fields = [];
    if (isset($_GET['category_id'])) {
        $search_fields['category_id'] = (int) $_GET['category_id'];
    }
    if (isset($_GET['area_id'])) {
        $search_fields['area_id'] = (int) $_GET['area_id'];
    }
    if (isset($_GET['ingredients']) && is_array($_GET['ingredients']) && count($_GET['ingredients']) > 0) {
        $search_fields['ingredients'] = $_GET['ingredients'];
    }

    if (count($search_fields) == 0) {
        $is_required_field_missing = true;
    }

    if ($is_required_field_missing) {
        $result['error']  = 'invalid_request';
        $result['error_message'] = 'Missing parameter' . var_export($_GET, true);
        goto end_of_page;
    }

    // db connection
    try {
        $db = new PDO(PDO_dsn, PDO_username, PDO_password);
    } catch (PDOException $exception) {
        $result['error']  = 'db_connection_error';
        $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
        goto end_of_page;
    }

    // meals - begin
    $meals = array();

    $inner_clauses = [];
    $where_conditions = [];
    $bind_values = [];
    if (isset($search_fields['category_id'])) {
        $where_conditions[] = 't1.category_id = :category_id';
        $bind_values[] = [':category_id', $search_fields['category_id'], PDO::PARAM_INT];
    }
    if (isset($search_fields['area_id'])) {
        $where_conditions[] = 't1.area_id = :area_id';
        $bind_values[] = [':area_id', $search_fields['area_id'], PDO::PARAM_INT];
    }

    if (isset($search_fields['ingredients'])) {
        $title_placeholders = [];

        $nr = 0;
        foreach ($search_fields['ingredients'] as $ingredient) {
            $nr++;
            $bind_values[] = [":title$nr", $ingredient, PDO::PARAM_STR];
            $title_placeholders[] = ":title$nr";
        }
        $title_placeholders_part = implode(',', $title_placeholders);
        $where_conditions[] = "EXISTS (SELECT 1 FROM meal_ingredients INNER JOIN ingredients ON meal_ingredients.ingredient_id = ingredients.id WHERE meal_id = t1.id AND ingredients.title IN ($title_placeholders_part)) ";
    }

    $where_clause = implode(' AND ', $where_conditions);
    $inner_clause = implode(' ', $inner_clauses);

    $sql
        = <<<EOF
SELECT
t1.id,
t1.title,
t1.image_url
FROM meals t1
$inner_clause
WHERE
$where_clause;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeals';
        goto end_of_page;
    }

    // Bind values
    foreach ($bind_values as $bind_value) {
        $stmt->bindValue($bind_value[0], $bind_value[1], $bind_value[2]);
    }

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeals';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $row['ingredients'] = [];
        $meals[$row['id']] = $row;
    }
    $stmt->closeCursor();
    // meals - end

    // searched ingredients - begin
    $searched_ingredients = [];
    $searched_ingredient_ids = [];
    if (isset($search_fields['ingredients'])) {
        $bind_values = [];
        $title_placeholders = [];

        $nr = 0;
        foreach ($search_fields['ingredients'] as $ingredient) {
            $nr++;
            $bind_values[] = [":title$nr", $ingredient, PDO::PARAM_STR];
            $title_placeholders[] = ":title$nr";
        }
        $title_placeholders_part = implode(',', $title_placeholders);

        $sql
            = <<<EOF
SELECT
t1.id,
t1.title
FROM ingredients t1
WHERE
t1.title IN ($title_placeholders_part);
EOF;

        $stmt = $db->prepare($sql);
        if ($stmt === false) {
            $result_array['error']  = 'query_error';
            $result_array['error_message'] = 'fetchSearchedIngredients';
            goto end_of_page;
        }

        // Bind values
        foreach ($bind_values as $bind_value) {
            $stmt->bindValue($bind_value[0], $bind_value[1], $bind_value[2]);
        }

        $r = $stmt->execute();
        if ($r === false) {
            $result_array['error']  = 'query_error';
            $result_array['error_message'] = 'fetchSearchedIngredients';
            goto end_of_page;
        }
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $searched_ingredients[$row['id']] = $row;
            $searched_ingredient_ids[] = $row['id'];
        }
        $stmt->closeCursor();
    }
    // searched ingredients - end

    // meal ingredients - begin
    if (count($meals) > 0) {
        $meal_ids = array_column($meals, 'id');
        $in_part = implode(',', $meal_ids);

        $sql
            = <<<EOF
SELECT
t1.meal_id,
t1.ingredient_id,
t1.measure,
t2.title,
t2.description
FROM meal_ingredients t1
INNER JOIN ingredients t2 ON t1.ingredient_id = t2.id
WHERE
t1.meal_id IN ($in_part);
EOF;

        $stmt = $db->prepare($sql);
        if ($stmt === false) {
            $result_array['error']  = 'query_error';
            $result_array['error_message'] = 'fetchMealIngredients';
            goto end_of_page;
        }

        $r = $stmt->execute();
        if ($r === false) {
            $result_array['error']  = 'query_error';
            $result_array['error_message'] = 'fetchMealIngredients';
            goto end_of_page;
        }
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $meals[$row['meal_id']]['ingredients'][$row['ingredient_id']] = $row;
        }
        $stmt->closeCursor();
    }
    // meal ingredients - end

    // calculate ingredient counts
    foreach ($meals as &$meal) {
        $matched = [];
        $missing = [];
        $unused = [];

        foreach ($meal['ingredients'] as $meal_ingredient) {
            if (in_array($meal_ingredient['ingredient_id'], $searched_ingredient_ids)) {
                $matched[] = $meal_ingredient;
            } else {
                $missing[] = $meal_ingredient;
            }
        }

        foreach ($searched_ingredients as $searched_ingredient_id => $searched_ingredient) {
            if (!in_array($searched_ingredient_id, array_keys($meal['ingredients']))) {
                $unused[] = $searched_ingredient;
            }
        }

        $meal['matched'] = $matched;
        $meal['missing'] = $missing;
        $meal['unused'] = $unused;
        $meal['missing_count'] = count($missing);
        $meal['matched_count'] = count($matched);
        $meal['unused_count'] = count($searched_ingredient_ids) - count($matched);
    }

    // sort meals
    usort($meals, function($a, $b) {
        $missing_count_a = count($a['missing']);
        $missing_count_b = count($b['missing']);
        $matched_count_a = count($a['matched']);
        $matched_count_b = count($b['matched']);

        if ($missing_count_a < $missing_count_b) {
            return -1;
        } elseif ($missing_count_a > $missing_count_b) {
            return 1;
        }

        if ($matched_count_a > $matched_count_b) {
            return -1;
        } else {
            return 1;
        }

        return 0;
    });

    $result['status'] = 'success';
    $result['values'] = ['meals' => $meals];
}
end_of_page:
