<?php
if (isset($result)) {
    $_GET = $_REQUEST;

    // check for required fields
	$is_required_field_missing = false;

    if (!isset($_GET['id'])) {
        $is_required_field_missing = true;
    }

    if ($is_required_field_missing) {
        $result['error']  = 'invalid_request';
        $result['error_message'] = 'Missing parameter';
        goto end_of_page;
    }

    // db connection
    try {
        $db = new PDO(PDO_dsn, PDO_username, PDO_password);
    } catch (PDOException $exception) {
        $result['error']  = 'db_connection_error';
        $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
        goto end_of_page;
    }

    // meal ingredients - begin
    $meal_ingredients = array();

    $sql
        = <<<EOF
SELECT
t1.id,
t1.ingredient_id,
t1.measure,
t2.title,
t2.description
FROM meal_ingredients t1
INNER JOIN ingredients t2 ON t1.ingredient_id = t2.id
WHERE
t1.meal_id = :meal_id
ORDER BY t1.id ASC;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMealIngredients';
        goto end_of_page;
    }

    $meal_id = (int) $_GET['id'];

    // Bind values
    $stmt->bindValue(':meal_id', $meal_id, PDO::PARAM_INT);

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMealIngredients';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $meal_ingredients[] = $row;
    }
    $stmt->closeCursor();
    // meal ingredients - end

    // meal details - begin
    $meal_details = array();

    $sql
        = <<<EOF
SELECT
t1.id,
t1.title,
t1.category_id,
t1.image_url,
t1.instructions,
t1.video_url,
t1.source,
t1.drink_alternate,
t1.area_id,
t2.title AS category_title,
t3.title AS area_title
FROM meals t1
LEFT JOIN categories t2 ON t1.category_id = t2.id
LEFT JOIN areas t3 ON t1.area_id = t3.id
WHERE
t1.id = :id;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeal';
        goto end_of_page;
    }

    $id = (int) $_GET['id'];

    // Bind values
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeal';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $row['ingredients'] = $meal_ingredients;
        $meal_details = $row;
    }
    $stmt->closeCursor();
    // meal details - end

    $result['status'] = 'success';
    $result['values'] = ['meal_details' => $meal_details];
}
end_of_page:
