<?php
if (isset($result)) {
    // check for required fields
	$is_required_field_missing = false;

    // db connection
    try {
        $db = new PDO(PDO_dsn, PDO_username, PDO_password);
    } catch (PDOException $exception) {
        $result['error']  = 'db_connection_error';
        $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
        goto end_of_page;
    }

    // ingredients - begin
    $ingredients = array();

    $sql
        = <<<EOF
SELECT
t1.id,
t1.title
FROM ingredients t1
ORDER BY t1.title ASC;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchIngredients';
        goto end_of_page;
    }

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchIngredients';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $ingredients[] = $row;
    }
    $stmt->closeCursor();
    // ingredients - end

    $result['status'] = 'success';
    $result['values'] = ['ingredients' => $ingredients];
}
end_of_page:
