<?php
if (isset($result)) {
    // check for required fields
	$is_required_field_missing = false;

    // db connection
    try {
        $db = new PDO(PDO_dsn, PDO_username, PDO_password);
    } catch (PDOException $exception) {
        $result['error']  = 'db_connection_error';
        $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
        goto end_of_page;
    }

    // categories - begin
    $categories = array();

    $sql
        = <<<EOF
SELECT
t1.id,
t1.title,
t1.image_url,
t1.description
FROM categories t1
ORDER BY t1.title ASC;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchCategories';
        goto end_of_page;
    }

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchCategories';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = $row;
    }
    $stmt->closeCursor();
    // categories - end

    $result['status'] = 'success';
    $result['values'] = ['categories' => $categories];
}
end_of_page:
