<?php
if (isset($result)) {
    // check for required fields
	$is_required_field_missing = false;

    if (!isset($_GET['area_id'])) {
        $is_required_field_missing = true;
    }

    if ($is_required_field_missing) {
        $result['error']  = 'invalid_request';
        $result['error_message'] = 'Missing parameter';
        goto end_of_page;
    }

    // db connection
    try {
        $db = new PDO(PDO_dsn, PDO_username, PDO_password);
    } catch (PDOException $exception) {
        $result['error']  = 'db_connection_error';
        $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
        goto end_of_page;
    }

    // meals - begin
    $meals = array();

    $sql
        = <<<EOF
SELECT
t1.id,
t1.title,
t1.image_url
FROM meals t1
WHERE
t1.area_id = :area_id
ORDER BY t1.title ASC;
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeals';
        goto end_of_page;
    }

    $area_id = (int) $_GET['area_id'];

    // Bind values
    $stmt->bindValue(':area_id', $area_id, PDO::PARAM_INT);

    $r = $stmt->execute();
    if ($r === false) {
        $result_array['error']  = 'query_error';
        $result_array['error_message'] = 'fetchMeals';
        goto end_of_page;
    }
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $meals[] = $row;
    }
    $stmt->closeCursor();
    // meals - end

    $result['status'] = 'success';
    $result['values'] = ['meals' => $meals];
}
end_of_page:
