<?php
/**
 * Created by PhpStorm.
 * User: Ovunc
 * Date: 3.08.2020
 * Time: 14:01
 */

class Functions
{
    /**
     * @param $card_number
     * @return string
     */
    static function getCreditCardBrand($card_number){
        $brand = '';

        // Card Type	Card Number Prefix
        // American Express	34, 37
        // China UnionPay	62, 88
        // Diners ClubCarte Blanche	300-305
        // Diners Club International	300-305, 309, 36, 38-39
        // Diners Club US & Canada	54, 55
        // Discover Card	6011, 622126-622925, 644-649, 65
        // JCB	3528-3589
        // Laser	6304, 6706, 6771, 6709
        // Maestro	5018, 5020, 5038, 5612, 5893, 6304, 6759, 6761, 6762, 6763, 0604, 6390
        // Dankort	5019
        // MasterCard	50-55
        // Visa	4
        // Visa Electron	4026, 417500, 4405, 4508, 4844, 4913, 4917

        $regex_maestro = '/^(5018|5020|5038|5612|589[0-3]|6304|6759|676[1-3]|0604|6390)/';
        $regex_mastercard = '/^5[0-5]/';
        $regex_visa = '/^4/';
        $regex_amex = '/^3[47]/';
        $regex_troy = '/^9792/';

        if (preg_match($regex_maestro, $card_number)){
            //$brand = 'maestro';
            $brand = 'mastercard';
        }
        elseif (preg_match($regex_mastercard, $card_number)){
            $brand = 'mastercard';
        }
        elseif (preg_match($regex_visa, $card_number)){
            $brand = 'visa';
        }
        elseif (preg_match($regex_amex, $card_number)){
            $brand = 'amex';
        }
        elseif (preg_match($regex_troy, $card_number)){
            $brand = 'troy';
        }

        return $brand;
    }

    /**
     * @param string $link
     * @param array $post_data
     * @return mixed
     */
    static function Ziraat_makePostRequest($link = '', $post_data = array())
    {
        if (isset($post_data['data'])){
            $post_data = $post_data['data'];
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $link);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, 1);
        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }

    /**
     * @param $details
     * @return mixed
     */
    static function Ziraat_chargePOSPayment($details)
    {
        $str_xml_elements = '';
        foreach ($details as $tag => $value){
            if (trim($value) == ''){
                continue;
            }
            $str_xml_elements .= "<{$tag}>{$value}</{$tag}>";
        }

        $xml = 'prmstr=<VposRequest>' . $str_xml_elements . '<CustomItems><Item name="Açıklama" value="Online Bilet Satışı" /></CustomItems></VposRequest>';

        $input_fields = array();
        $input_fields['data'] = $xml;

        $response = self::Ziraat_makePostRequest('https://sanalpos.ziraatbank.com.tr/v4/v3/Vposreq.aspx', $input_fields);

        return $response;
    }

    /**
     * @param $details
     * @return mixed
     */
    static function Ziraat_charge3DSecurePayment($details)
    {
        $str_xml_elements = '';
        foreach ($details as $tag => $value){
            if (trim($value) == ''){
                continue;
            }
            $str_xml_elements .= "<{$tag}>{$value}</{$tag}>";
        }

        $xml = 'prmstr=<VposRequest>' . $str_xml_elements . '<CustomItems><Item name="Açıklama" value="Online Bilet Satışı" /></CustomItems></VposRequest>';

        $input_fields = array();
        $input_fields['data'] = $xml;

        $response = self::Ziraat_makePostRequest('https://sanalpos.ziraatbank.com.tr/v4/v3/Vposreq.aspx', $input_fields);

        return $response;
    }

	static function xor_encode($str,$key)
	{
		$output = '';
		$key = base64_encode($key);
		$str = base64_encode($str);
		$str_len = strlen($str);
		$key_len = strlen($key);
		for ($i=0;$i<$str_len;$i++){
			$output .= $str[$i] ^ $key[$i % $key_len];
		}
		return base64_encode($output);
	}
	static function xor_decode($str,$key)
	{
		$str = base64_decode($str);
		$output = '';
		$key = base64_encode($key);
		$key_len = strlen($key);
		$str_len = strlen($str);
		for ($i=0;$i<$str_len;$i++){
			$output .= $str[$i] ^ $key[$i % $key_len];
		}
		return base64_decode($output);
	}
}