<?php
ini_set('max_execution_time', 0);
require_once("site/config/site.php");
require_once("site/config/auto_loaders.php");
require_once("site/config/db.php");

$result = array();
$result['error'] = '';
$result['error_message'] = '';

// db connection
try {
    $db = new PDO(PDO_dsn, PDO_username, PDO_password);
} catch (PDOException $exception) {
    $result['error']  = 'db_connection_error';
    $result['error_message'] = $exception->getCode() . ' - ' . $exception->getMessage();
    goto end_of_page;
}


// categories - begin
$categories = array();

$sql
    = <<<EOF
SELECT
t1.id,
t1.title,
t1.image_url,
t1.description
FROM categories t1
ORDER BY t1.title ASC;
EOF;

$stmt = $db->prepare($sql);
if ($stmt === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchCategories';
    goto end_of_page;
}

$r = $stmt->execute();
if ($r === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchCategories';
    goto end_of_page;
}
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $categories[] = $row;
}
$stmt->closeCursor();
// categories - end

// areas - begin
$areas = array();

$sql
    = <<<EOF
SELECT
t1.id,
t1.title
FROM areas t1
ORDER BY t1.title ASC;
EOF;

$stmt = $db->prepare($sql);
if ($stmt === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchAreas';
    goto end_of_page;
}

$r = $stmt->execute();
if ($r === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchAreas';
    goto end_of_page;
}
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $areas[$row['title']] = $row;
}
$stmt->closeCursor();
// areas - end

// ingredients - begin
$ingredients = array();

$sql
    = <<<EOF
SELECT
t1.id,
t1.title
FROM ingredients t1
ORDER BY t1.title ASC;
EOF;

$stmt = $db->prepare($sql);
if ($stmt === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchIngredients';
    goto end_of_page;
}

$r = $stmt->execute();
if ($r === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchIngredients';
    goto end_of_page;
}
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $ingredients[prepare_ingredient_key($row['title'])] = $row;
}
$stmt->closeCursor();
// ingredients - end

// categories - begin
$categories = array();

$sql
    = <<<EOF
SELECT
t1.id,
t1.title,
t1.image_url,
t1.description
FROM categories t1
ORDER BY t1.title ASC;
EOF;

$stmt = $db->prepare($sql);
if ($stmt === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchCategories';
    goto end_of_page;
}

$r = $stmt->execute();
if ($r === false) {
    $result_array['error']  = 'query_error';
    $result_array['error_message'] = 'fetchCategories';
    goto end_of_page;
}
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $categories[] = $row;
}
$stmt->closeCursor();
// categories - end

goto end_of_page;

goto get_meals;
goto get_ingredients;
goto get_areas;
goto get_categories;

function prepare_ingredient_key($title) {
    $title = strtolower($title);
    $title = str_replace(' ', '', $title);
    return $title;
}


get_meals:
//var_dump($ingredients);
//exit;
foreach ($categories as $category) {
    $url = 'https://www.themealdb.com/api/json/v1/1/filter.php?c=' . $category['title'];
    $response = CURLClient::get($url);
    $response_array = json_decode($response, true);
    $category_meals = $response_array['meals'];

    foreach ($category_meals as $category_meal) {
        $url = 'https://www.themealdb.com/api/json/v1/1/lookup.php?i=' . $category_meal['idMeal'];
        $response = CURLClient::get($url);
        $response_array = json_decode($response, true);

        foreach ($response_array['meals'] as $meal) {
            // create new meal - begin
            $sql
                = <<<EOF
INSERT INTO meals
(
id,
title,
category_id,
image_url,
instructions,
video_url,
source,
drink_alternate,
area_id
) 
VALUES
(
:id,
:title,
:category_id,
:image_url,
:instructions,
:video_url,
:source,
:drink_alternate,
:area_id
);
EOF;

            $stmt = $db->prepare($sql);
            if ($stmt === false) {
                $result['error']  = 'query_error';
                $result['error_message'] = 'PostMeal';
                goto end_of_page;
            }

            $area_id = empty($areas[$meal['strArea']]['id']) ? null : $areas[$meal['strArea']]['id'];

            // Bind values
            $stmt->bindValue(':id', $meal['idMeal'], is_null($meal['idMeal']) ? PDO::PARAM_NULL : PDO::PARAM_INT);
            $stmt->bindValue(':title', $meal['strMeal'], is_null($meal['strMeal']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':category_id', $category['id'], is_null($category['id']) ? PDO::PARAM_NULL : PDO::PARAM_INT);
            $stmt->bindValue(':image_url', $meal['strMealThumb'], is_null($meal['strMealThumb']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':instructions', $meal['strInstructions'], is_null($meal['strInstructions']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':video_url', $meal['strYoutube'], is_null($meal['strYoutube']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':source', $meal['strSource'], is_null($meal['strSource']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':drink_alternate', $meal['strDrinkAlternate'], is_null($meal['strDrinkAlternate']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':video_url', $meal['strYoutube'], is_null($meal['strYoutube']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
            $stmt->bindValue(':area_id', $area_id, is_null($area_id) ? PDO::PARAM_NULL : PDO::PARAM_STR);

            $r = $stmt->execute();
            if ($r === false) {
                $result['error']  = 'query_error';
                $result['error_message'] = $db->errorCode();
                goto end_of_page;
            }
            // create new meal - end

            // create meal ingredients - begin
            $meal_ingredients = [];

            for ($i = 1; $i<=20; $i++) {
                if (!empty($meal['strIngredient' . $i])) {
                    $prepared_key = prepare_ingredient_key($meal['strIngredient' . $i]);
                    if ($prepared_key == 'gruyerecheese') {
                        $meal['strIngredient' . $i] = 'gruyère';
                    }elseif ($prepared_key == 'blackberrys') {
                        $meal['strIngredient' . $i] = 'blackberry';
                    } elseif ($prepared_key == 'butter,softened') {
                        $meal['strIngredient' . $i] = 'softenedbutter';
                    } elseif ($prepared_key == 'tomatopurée') {
                        $meal['strIngredient' . $i] = 'tomatopuree';
                    } elseif ($prepared_key == 'tarragon') {
                        $meal['strIngredient' . $i] = 'tarragonleaves';
                    } elseif ($prepared_key == 'redchili') {
                        $meal['strIngredient' . $i] = 'redchilli';
                    } elseif ($prepared_key == 'vermicelli') {
                        $meal['strIngredient' . $i] = 'Vermicelli Pasta';
                    } elseif ($prepared_key == 'selfraisingflour') {
                        $meal['strIngredient' . $i] = 'Self-raising Flour';
                    } elseif ($prepared_key == 'greenchili') {
                        $meal['strIngredient' . $i] = 'Green Chilli';
                    } elseif ($prepared_key == 'redchilipowder') {
                        $meal['strIngredient' . $i] = 'Red Chilli Powder';
                    } elseif ($prepared_key == 'harissa') {
                        $meal['strIngredient' . $i] = 'Harissa Spice';
                    } elseif (empty($ingredients[$prepared_key]) && !empty($ingredients[$prepared_key . 's'])) {
                        $meal['strIngredient' . $i] = $prepared_key . 's';
                    } elseif (empty($ingredients[$prepared_key]) && !empty($ingredients[$prepared_key . 'es'])) {
                        $meal['strIngredient' . $i] = $prepared_key . 'es';
                    }

                    $meal_ingredients[] = ['id' => $ingredients[prepare_ingredient_key($meal['strIngredient' . $i])]['id'], 'measure' => $meal['strMeasure' . $i]];
                }
            }

            foreach ($meal_ingredients as $meal_ingredient) {
                // create meal ingredient - begin
                $sql
                    = <<<EOF
INSERT INTO meal_ingredients
(
meal_id,
ingredient_id,
measure
) 
VALUES
(
:meal_id,
:ingredient_id,
:measure
);
EOF;

                $stmt = $db->prepare($sql);
                if ($stmt === false) {
                    $result['error']  = 'query_error';
                    $result['error_message'] = 'PostMealIngredient';
                    goto end_of_page;
                }

                // Bind values
                $stmt->bindValue(':meal_id', $meal['idMeal'], is_null($meal['idMeal']) ? PDO::PARAM_NULL : PDO::PARAM_INT);
                $stmt->bindValue(':ingredient_id', $meal_ingredient['id'], is_null($meal_ingredient['id']) ? PDO::PARAM_NULL : PDO::PARAM_INT);
                $stmt->bindValue(':measure', $meal_ingredient['measure'], is_null($meal_ingredient['measure']) ? PDO::PARAM_NULL : PDO::PARAM_STR);

                $r = $stmt->execute();
                if ($r === false) {
                    $result['error']  = 'query_error';
                    $result['error_message'] = $db->errorCode();
                    goto end_of_page;
                }
                // create meal ingredient - end
            }
        }
    }

}

exit;

get_ingredients:
$url = 'https://www.themealdb.com/api/json/v1/1/list.php?i=list';
$response = CURLClient::get($url);
$response_array = json_decode($response, true);

foreach ($response_array['meals'] as $meal) {
    // create new ingredient - begin
    $sql
        = <<<EOF
INSERT INTO ingredients
(
id,
title,
description,
type
) 
VALUES
(
:id,
:title,
:description,
:type
);
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = 'PostIngredient';
        goto end_of_page;
    }

    // Bind values
    $stmt->bindValue(':id', $meal['idIngredient'], PDO::PARAM_INT);
    $stmt->bindValue(':title', $meal['strIngredient'], PDO::PARAM_STR);
    $stmt->bindValue(':description', $meal['strDescription'], is_null($meal['strDescription']) ? PDO::PARAM_NULL : PDO::PARAM_STR);
    $stmt->bindValue(':type', $meal['strType'], is_null($meal['strType']) ? PDO::PARAM_NULL : PDO::PARAM_STR);

    $r = $stmt->execute();
    if ($r === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = $db->errorCode();
        goto end_of_page;
    }
    // create new ingredient - end
}
exit;

get_areas:
$url = 'https://www.themealdb.com/api/json/v1/1/list.php?a=list';
$response = CURLClient::get($url);
$response_array = json_decode($response, true);

foreach ($response_array['meals'] as $meal) {
    // create new area - begin
    $sql
        = <<<EOF
INSERT INTO areas
(
title
) 
VALUES
(
:title
);
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = 'PostArea';
        goto end_of_page;
    }

    // Bind values
    $stmt->bindValue(':title', $meal['strArea'], PDO::PARAM_STR);

    $r = $stmt->execute();
    if ($r === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = $db->errorCode();
        goto end_of_page;
    }
    // create new area - end
}
exit;

get_categories:
$url = 'https://www.themealdb.com/api/json/v1/1/categories.php';
$response = CURLClient::get($url);
$response_array = json_decode($response, true);

foreach ($response_array['categories'] as $category) {
    // create new category - begin
    $sql
        = <<<EOF
INSERT INTO categories
(
id,
title,
image_url,
description
) 
VALUES
(
:id,
:title,
:image_url,
:description
);
EOF;

    $stmt = $db->prepare($sql);
    if ($stmt === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = 'PostCategory';
        goto end_of_page;
    }

    // Bind values
    $stmt->bindValue(':id', $category['idCategory'], PDO::PARAM_INT);
    $stmt->bindValue(':title', $category['strCategory'], PDO::PARAM_STR);
    $stmt->bindValue(':image_url', $category['strCategoryThumb'], PDO::PARAM_STR);
    $stmt->bindValue(':description', $category['strCategoryDescription'], PDO::PARAM_STR);

    $r = $stmt->execute();
    if ($r === false) {
        $result['error']  = 'query_error';
        $result['error_message'] = $db->errorCode();
        goto end_of_page;
    }
    // create new category - end
}
exit;

goto end_of_page;

end_of_page:
